Attribute VB_Name = "Assemblydemo"
'	This is a part of the source code for Pro/DESKTOP.
'	Copyright (C) 1999 Parametric Technology Corporation.
'	All rights reserved.

Function menuWheelSpidleAssembly()

If prod Is Nothing Then
    MsgBox "Could not get the application", vbExclamation, "Error"
    Exit Function
End If

Dim wheelComponent As aGraphic
Dim spindleComponent As aGraphic

Rem Create  a wheel and a spindle
Call wheel
Call spindle


Dim helmObject As helm
Set helmObject = prod.TakeHelm

Rem Add component
Dim part As PartDocument
Set part = prod.NewPart
Set wheelComponent = cfobject.AddComponent("c:\wheel.des")
Set spindleComponent = cfobject.AddComponent("c:\spindle.des")

helmObject.CommitCalls "UpdateView", False


Rem Align Center Axes
helmObject.CommitCalls "UpdateView", False

MsgBox ("Select one Circular Edge of Spindle and one Circular Edge of Wheel for Center Axis Constraint")
helmObject.CommitCalls "Select Edges", True
Dim selectionSet1 As ObjectSet
Set selectionSet1 = part.GetSelection("Topology")

Dim selectionSetIt1 As Iterator
Set selectionSetIt1 = prod.GetClass("It").CreateAObjectIt(selectionSet1)

Dim topy1 As aTopology
Dim topy2 As aTopology
Set topy1 = selectionSetIt1.start
Set topy2 = selectionSetIt1.Next

'Assembly.menuCenterAxes topy1, topy2
cfobject.CenterAxes topy1, topy2

helmObject.CommitCalls "Center Axes", False

Rem Align Planes
helmObject.CommitCalls "UpdateView", False

MsgBox ("Select one Planar Face of Wheel and one Planar Face of Spindle for Align Constraint")
helmObject.CommitCalls "Select Faces", True
Dim selectionSet2 As ObjectSet
Set selectionSet2 = part.GetSelection("Topology")

Dim selectionSetIt2 As Iterator
Set selectionSetIt2 = prod.GetClass("It").CreateAObjectIt(selectionSet2)

'Assembly.menuAlignPlanes selectionSetIt2.start, selectionSetIt2.Next
cfobject.AlignPlanes part.GetDesign, selectionSetIt2.start, selectionSetIt2.Next, 0, "var" & CStr(CACount)
CACount = CACount + 1



helmObject.CommitCalls "Align Planes", False

Rem Save the Assembly
pathName = "c:\SubAssembly.des"

On Error GoTo SaveErr
ret = part.Close(pathName, True)
On Error GoTo 0

Exit Function

SaveErr:
        MsgBox "Could not Save the Active Part", vbExclamation, "Error"
        Exit Function
        
End Function

